package brs.visitor.traverse.test;

import brs.visitor.traverse.*;
import brs.visitor.*;
import fp.*;
import brs.*;

import junit.framework.TestCase;


public class Test_AlgebraicRep extends TestCase {
  

  public void test_result() {
    BiTree tree = new BiTree();
    IVisitor algo = new InOrder1(AlgebraicRep.Singleton);
    String b = "";
    assertEquals("Empty tree","",tree.execute(algo, b));

    tree.insertRoot("f1");
    assertEquals("1-elt tree","f1",tree.execute(algo, b));

    BiTree child = new BiTree();
    child.insertRoot("a");
    tree.setLeftSubTree(child);
    assertEquals("2-elt tree","f1(a)",tree.execute(algo, b));

    BiTree tree2 = new BiTree();
    tree2.insertRoot("f4");
    child = new BiTree();
    child.insertRoot("d");
    tree2.setRightSubTree(child);
    assertEquals("2-elt tree","f4(d)",tree2.execute(algo, b));
    
    BiTree tree3 = new BiTree();
    tree3.insertRoot("f3");
    child = new BiTree();
    child.insertRoot("b");
    tree3.setLeftSubTree(child);
    child = new BiTree();
    child.insertRoot("c");
    tree3.setRightSubTree(child);
    assertEquals("3-elt tree","f3(b, c)",tree3.execute(algo, b));
    
    BiTree tree4 = new BiTree();
    tree4.insertRoot("f2");
    tree4.setLeftSubTree(tree3);
    tree4.setRightSubTree(tree2);
    assertEquals("6-elt tree","f2(f3(b, c), f4(d))",tree4.execute(algo, b));
    
    tree.setRightSubTree(tree4);
    assertEquals("8-elt tree","f1(a, f2(f3(b, c), f4(d)))",tree.execute(algo, b));
    
  }
  
}
